-- --------------------------------------------------------------------------
-- Copyright  2008 PlayFirst, Inc. All Rights Reserved.
--
-- This material is the confidential trade secret and proprietary
-- information of PlayFirst, Inc. It may not be reproduced, used, disclosed,
-- sold or transferred without the prior written consent of PlayFirst, Inc. 
-- All rights reserved.
-- --------------------------------------------------------------------------
require( "scripts/tittle_style.lua" );


kButtonY = kMax-205;
kSpaceX = 37;

MakeDialog
{
	name="restartlevelbox", -- Remember, this is like saying table['name']=name, so it works.
    Bitmap
    {
		image="images/ui/common/popup03",
		x=kCenter,
		y=kCenter,


        Text
		{
			name = "yesnotitle",
			label= gDialogTable.title,
			font = PopupCopyright,
			flags = kVAlignCenter + kHAlignCenter,
			x=0,y=140,w=kMax,h=30
		};
		
		SetStyle(DialogBodyText),
		Text
		{
			name = "yesnobody",
			label= "ui.dialog.restart.confirm",
		};

        SetStyle(FitnessButtonStyleTittleSmallBlue2),
        
        SBButton
        {
			x = kCenter-kSpaceX,
            y = kButtonY,
            label	= "yes",
            icon="assets/images/ui/buttons/icon/iconok",
			command=
				function()
					PopModal("restartlevelbox");
					SendGameMessage( "ui.dialog.restartlevel.title" );
				end;
        },
        SBButton
        {
			command=
				function() 
					PopModal("restartlevelbox");
					DoModal("scripts/pause.lua");
                end;
            icon="assets/images/ui/buttons/icon/iconcancel",
            label= "no",
            x = kCenter+kSpaceX,
            y = kButtonY,
        },
    },

} -- MakeDialog
